/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityMotionLight;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMotionActivatedLight
extends BlockOwnable {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockMotionActivatedLight(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        float px = 0.0625f;
        if (dir == EnumFacing.NORTH) {
            return new AxisAlignedBB((double)(px * 6.0f), (double)(px * 3.0f), 0.0, (double)(px * 10.0f), (double)(px * 9.0f), (double)(px * 3.0f));
        }
        if (dir == EnumFacing.SOUTH) {
            return new AxisAlignedBB((double)(px * 6.0f), (double)(px * 3.0f), 1.0, (double)(px * 10.0f), (double)(px * 9.0f), (double)(1.0f - px * 3.0f));
        }
        if (dir == EnumFacing.EAST) {
            return new AxisAlignedBB(1.0, (double)(px * 3.0f), (double)(px * 6.0f), (double)(1.0f - px * 3.0f), (double)(px * 9.0f), (double)(px * 10.0f));
        }
        if (dir == EnumFacing.WEST) {
            return new AxisAlignedBB(0.0, (double)(px * 3.0f), (double)(px * 6.0f), (double)(px * 3.0f), (double)(px * 9.0f), (double)(px * 10.0f));
        }
        return new AxisAlignedBB((double)(px * 6.0f), (double)(px * 3.0f), 0.0, (double)(px * 10.0f), (double)(px * 9.0f), (double)(px * 3.0f));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public static void toggleLight(World world, BlockPos pos, double searchRadius, Owner owner, boolean isLit) {
        if (!world.field_72995_K) {
            if (isLit) {
                BlockUtils.setBlockProperty(world, pos, LIT, true);
                if ((IOwnable)world.func_175625_s(pos) != null) {
                    ((IOwnable)world.func_175625_s(pos)).setOwner(owner.getUUID(), owner.getName());
                }
                BlockUtils.updateAndNotify(world, pos, SCContent.motionActivatedLight, 1, false);
            } else {
                BlockUtils.setBlockProperty(world, pos, LIT, false);
                if ((IOwnable)world.func_175625_s(pos) != null) {
                    ((IOwnable)world.func_175625_s(pos)).setOwner(owner.getUUID(), owner.getName());
                }
                BlockUtils.updateAndNotify(world, pos, SCContent.motionActivatedLight, 1, false);
            }
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (!this.func_176198_a(world, pos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d()) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 15) {
            return this.func_176223_P();
        }
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta].func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177228_b().containsKey((Object)LIT) && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        if (!state.func_177228_b().containsKey((Object)FACING)) {
            return 15;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMotionLight().attacks(EntityPlayer.class, SecurityCraft.config.motionActivatedLightSearchRadius, 1);
    }
}

